<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';

function route_withdraw($method, $path) {
  if ($method==='POST' && $path==='/api/withdraw') return api_withdraw();
}

function api_withdraw() {
  $u = require_user();
  $b = json_decode(file_get_contents('php://input'), true) ?: [];
  $walletId = intval($b['walletId'] ?? 0);
  $to = trim($b['toAddress'] ?? '');
  $amount = floatval($b['amount'] ?? 0);

  if ($walletId<=0 || $to==='' || $amount<=0) json_error(400,'bad request');

  $pdo = db();
  $st = $pdo->prepare("SELECT id, walletaddress, balance, encryptedprivatekey
                       FROM wallets WHERE id=? AND userid=? AND cointype='USDTTRC20' LIMIT 1");
  $st->execute([$walletId, $u['user_id']]);
  $w = $st->fetch();
  if (!$w) json_error(404,'wallet not found');
  if (floatval($w['balance']) < $amount) json_error(400,'insufficient balance');

  $pdo->prepare("INSERT INTO transactions
      (walletid, transactionhash, fromaddress, toaddress, amount, fee, cointype, status, confirmations, transactiontype, createdat)
      VALUES (?, 'PENDING', ?, ?, ?, 0, 'USDTTRC20', 'pending', 0, 'send', NOW())")
    ->execute([$walletId, $w['walletaddress'], $to, $amount]);
  $txRowId = intval($pdo->lastInsertId());

  $payload = [
    'encryptedPrivateKey' => $w['encryptedprivatekey'],
    'toAddress' => $to,
    'amountDecimal' => $amount
  ];

  $ch = curl_init(SIGNER_URL . '/send-usdt');
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => array_values(array_filter([
      'Content-Type: application/json',
      INTERNAL_TOKEN ? ('X-Internal-Token: '.INTERNAL_TOKEN) : null
    ])),
    CURLOPT_POSTFIELDS => json_encode($payload)
  ]);
  $resp = curl_exec($ch);
  if ($resp === false) json_error(500, 'signer unreachable');
  $j = json_decode($resp, true);
  if (!($j['ok'] ?? false)) json_error(500, 'send failed');

  $txid = $j['data']['txid'] ?? null;
  if (!$txid && isset($j['data']['transaction']['txID'])) $txid = $j['data']['transaction']['txID'];
  if (!$txid) $txid = 'BROADCASTED';

  $pdo->prepare("UPDATE transactions SET transactionhash=? WHERE id=?")->execute([$txid, $txRowId]);

  json_ok(['transactionId'=>$txRowId, 'txHash'=>$txid]);
}
