<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';

function route_wallets($method, $path) {
  if ($method==='POST' && $path==='/api/wallets/create') return api_wallet_create();
  if ($method==='GET'  && $path==='/api/wallets') return api_wallet_list();
}

function api_wallet_create() {
  $u = require_user();

  $ch = curl_init(SIGNER_URL . '/create-wallet');
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => array_values(array_filter([
      'Content-Type: application/json',
      INTERNAL_TOKEN ? ('X-Internal-Token: '.INTERNAL_TOKEN) : null
    ])),
    CURLOPT_POSTFIELDS => json_encode(new stdClass())
  ]);
  $resp = curl_exec($ch);
  if ($resp === false) json_error(500, 'signer unreachable');
  $j = json_decode($resp, true);
  if (!($j['ok'] ?? false)) json_error(500, 'signer error');

  $addr = $j['data']['address'];
  $pub = $j['data']['publicKey'];
  $encPk = $j['data']['encryptedPrivateKey'];

  $pdo = db();
  $st = $pdo->prepare("INSERT INTO wallets (userid,walletaddress,cointype,balance,encryptedprivatekey,publickey,createdat,updatedat)
                       VALUES (?,?, 'USDTTRC20', 0, ?, ?, NOW(), NOW())");
  $st->execute([$u['user_id'],$addr,$encPk,$pub]);

  json_ok(['walletId'=>intval($pdo->lastInsertId()), 'address'=>$addr]);
}

function api_wallet_list() {
  $u = require_user();
  $pdo = db();
  $st = $pdo->prepare("SELECT id,walletaddress,cointype,balance,createdat,updatedat FROM wallets WHERE userid=? ORDER BY id DESC");
  $st->execute([$u['user_id']]);
  json_ok($st->fetchAll());
}
