<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';

function route_transactions($method, $path) {
  if ($method==='GET' && $path==='/api/transactions') return api_transactions();
}

function api_transactions() {
  $u = require_user();
  $walletId = intval($_GET['walletId'] ?? 0);

  $pdo = db();
  $st = $pdo->prepare("SELECT id FROM wallets WHERE id=? AND userid=? LIMIT 1");
  $st->execute([$walletId, $u['user_id']]);
  if (!$st->fetch()) json_error(404,'wallet not found');

  $st = $pdo->prepare("SELECT * FROM transactions WHERE walletid=? ORDER BY id DESC LIMIT 200");
  $st->execute([$walletId]);
  json_ok($st->fetchAll());
}
